<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * Class Hostpinacle
 */
class Hostpinacle
{
    /**
     * @var $api_key
     * @var $senderID
     * @var $username
     * @var $api_endpoint
     * @var $account_balance_endpoint
     * @var $delivery_report_endpoint
     */
    protected static $api_key;
    protected static $senderID;
    protected static $username;
    protected static $password;
    protected static $api_endpoint = "https://sms.biznr.co.ke/SMSApi/send";
    protected static $account_balance_endpoint = "https://sms.biznr.co.ke/SMSApi/account/readstatus";
    protected static $delivery_report_endpoint = '';

    public static function init($api_key, $senderID, $username, $password)
    {  
        self::$senderID = $senderID;
        self::$api_key = $api_key;
        self::$username = $username;
        self::$password = $password;
    }

    /**
     * @param $mobile
     * @param $message
     * @param string $method
     * @return mixed
     */
    public static function send($mobile, $message, $name, $method = "POST")
    {   
        $request = "?userid=" . urlencode(self::$username) .
            "&password=" . self::$password .
            "&sendMethod=" . 'quick' .
            "&senderid=" . urlencode(self::$senderID) .
            "&msg=" . urlencode($message) .
            "&msgType=" . 'text' .
            "&duplicatecheck=" . 'true' .
            "&output=" . 'json' .
            "&mobile=" . self::formatPhone($mobile);
			
		$response = self::$sendSMSGet($request);

        if ($response) {
            if (isset($response) && $response['status']== 'success' && $response['statusCode'] === 200) {
                $stdat = array(
                    'usertypeID'        => '0',
                    'users'             => $name,
                    'type'              => ucfirst('automated'),
                    'message'           => $message,
                    'year'              => date('Y'),
                    'senderusertypeID'  => 1,
                    'senderID'          => self::$senderID
                );
    
                $ci = &get_instance();
                $ci->load->model("mailandsms_m");
                $ci->mailandsms_m->insert_mailandsms($stdat);
    
                self::account_balance();
            }
        }
    
        return true;
    }    

    /**
     * @return mixed
     */

    public static function sendGroupSMS($phones, $message){
        $params['phone'] = $phones;
		$params['message'] = $message;

		$this->sendSMSGet($params);

        foreach($phones as $phone){
            $stdat = array(
                'usertypeID'        => '0',
                'users'             => $phone,
                'type'              => ucfirst('automated'),
                'message'           => $message,
                'year'              => date('Y'),
                'senderusertypeID'  => 1,
                'senderID'          => self::$senderID
            );

            $ci = &get_instance();
            $ci->load->model("mailandsms_m");
            $ci->mailandsms_m->insert_mailandsms($stdat);

        }
        self::account_balance();

		return true;
    }

    public static function account_balance(){

        $request = "?userid=" . urlencode(self::$username) .
            "&password=" . self::$password .
            "&output=" . 'json';
        $response = self::$sendSMSGet($request);

        if($response['status'] === 'success' && $response['code'] === 200){
            $ci     = &get_instance();
            $ci->load->model("smssettings_m");

            $array = array(            
                array(
                    'field_names' => 'celcom_balance',
                    'field_values' => $response['account']['smsBalance']
                )
            );

            $ci->smssettings_m->update_celcom($array);
        }        

       return $result ;
    }

    /**
     * @param $message
     * @param $mobile
     * @param $time
     * @return mixed
     */
    public static function schedule($message, $mobile, $time){
        if(get_setting('system_notification')){
            $request = array(
                'apikey'=>self::$api_key,
                'partnerID'=>self::$partner_id,
                'shortcode'=>self::$shortcode,
                'message'=>$message ,
                'mobile'=>$mobile ,
                'timeToSend'=>$time /*timestamp or datetime*/
            );

            $request = json_encode($request); /*convert to json for processing*/
            $response = self::$send_post_request($request);
            return $response;
        }

        return [];
        
    }

    /**
     * @param $data
     * @param $term
     * @param $message
     * @return mixed|string
     */
    public static function customize_message($data, $term, $message){
        if(!$message){
            return "";
        }
        $term_index = str_replace("{",'',str_replace("}",'',$term));
        if(array_key_exists($term_index,$data)){
            $message = str_replace($term,$data[$term_index],$message);
        }
        return $message;
    }

    public static function formatPhone($mobile) {
        if (is_array($mobile)) {
            $mobile = reset($mobile);
        }
    
        if (substr($mobile, 0, 1) == "+") {
            $mobile = str_replace("+", "", $mobile);
        }
        if (substr($mobile, 0, 1) == "0") {
            $mobile = preg_replace("/^0/", "254", $mobile);
        }
        if (substr($mobile, 0, 1) == "7" && strlen($mobile) == 9) {
            $mobile = "254{$mobile}";
        }
    
        return $mobile;
    }    

    public static function sendSMSGet($request)
    {
    
        $url = self::$api_endpoint . $request;
        
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "cache-control: no-cache"
          ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        $result = json_decode($response,true);
        return $result;
    }    
}